/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.tconstruct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.ToIntFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.tconstruct.TConstructHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"tconstruct"})
public class TConstructCompatModule
implements IModule {
    private static final Set<String> MATERIAL_BLACKLIST;
    private static final Set<String> STORAGE_BLOCK_BLACKLIST;
    private static final Set<String> NUGGET_BLACKLIST;
    private static final Set<String> DUST_BLACKLIST;
    private static final Set<String> PLATE_BLACKLIST;
    private static final Set<String> COIN_BLACKLIST;
    private static final Set<String> GENERAL_BLACKLIST;
    private static Set<String> configMaterialToMoltenBlacklist;
    private static Set<String> configStorageBlockToMoltenBlacklist;
    private static Set<String> configNuggetToMoltenBlacklist;
    private static Set<String> configDustToMoltenBlacklist;
    private static Set<String> configPlateToMoltenBlacklist;
    private static Set<String> configGearToMoltenBlacklist;
    private static Set<String> configCoinToMoltenBlacklist;
    private static Set<String> configRodToMoltenBlacklist;
    private static Set<String> configSheetmetalToMoltenBlacklist;
    private static Set<String> configToMaterialBlacklist;
    private static Set<String> configToStorageBlockBlacklist;
    private static Set<String> configToNuggetBlacklist;
    private static Set<String> configToPlateBlacklist;
    private static Set<String> configToGearBlacklist;
    private static Set<String> configToCoinBlacklist;
    private static Set<String> configToRodBlacklist;
    private static boolean jaopcaOnly;

    @Override
    public String getName() {
        return "tconstruct_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        jaopcaOnly = config.getDefinedBoolean("recipes.jaopcaOnly", jaopcaOnly, "Should the module only add recipes for materials with JAOPCA molten fluids.");
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.materialToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have ingot/gem melting recipes added."), configMaterialToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.storageBlockToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have storage block melting recipes added."), configStorageBlockToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.nuggetToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have nugget melting recipes added."), configNuggetToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.dustToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have dust melting recipes added."), configDustToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.plateToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have plate melting recipes added."), configPlateToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.gearToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have gear melting recipes added."), configGearToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.coinToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have coin melting recipes added."), configCoinToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.rodToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have rod melting recipes added."), configRodToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.sheetmetalToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have sheetmetal melting recipes added."), configSheetmetalToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toMaterialMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have ingot/gem casting recipes added."), configToMaterialBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toStorageBlockMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have storage block casting recipes added."), configToStorageBlockBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toNuggetMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have nugget casting recipes added."), configToNuggetBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toPlateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have plate casting recipes added."), configToPlateBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toGearMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have gear casting recipes added."), configToGearBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toCoinMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have coin casting recipes added."), configToCoinBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toRodMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have rod casting recipes added."), configToRodBlacklist);
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        TConstructHelper helper = TConstructHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<ResourceLocation> itemTags = ((JAOPCAApi)api).getItemTags();
        Set<ResourceLocation> fluidTags = ((JAOPCAApi)api).getFluidTags();
        Set<IMaterial> moltenMaterials = ((JAOPCAApi)api).getForm("molten").getMaterials();
        ToIntFunction<FluidStack> tempFunction = stack -> stack.getFluid().getAttributes().getTemperature(stack) - 300;
        ToIntFunction<FluidStack> castTimeFunction = stack -> ICastingRecipe.calcCoolingTime((FluidStack)stack);
        ResourceLocation ingotCastMultiLocation = new ResourceLocation("tconstruct:casts/multi_use/ingot");
        ResourceLocation ingotCastSingleLocation = new ResourceLocation("tconstruct:casts/single_use/ingot");
        ResourceLocation gemCastMultiLocation = new ResourceLocation("tconstruct:casts/multi_use/gem");
        ResourceLocation gemCastSingleLocation = new ResourceLocation("tconstruct:casts/single_use/gem");
        ResourceLocation nuggetCastMultiLocation = new ResourceLocation("tconstruct:casts/multi_use/nugget");
        ResourceLocation nuggetCastSingleLocation = new ResourceLocation("tconstruct:casts/single_use/nugget");
        ResourceLocation plateCastMultiLocation = new ResourceLocation("tconstruct:casts/multi_use/plate");
        ResourceLocation plateCastSingleLocation = new ResourceLocation("tconstruct:casts/single_use/plate");
        ResourceLocation gearCastMultiLocation = new ResourceLocation("tconstruct:casts/multi_use/gear");
        ResourceLocation gearCastSingleLocation = new ResourceLocation("tconstruct:casts/single_use/gear");
        ResourceLocation coinCastMultiLocation = new ResourceLocation("tconstruct:casts/multi_use/coin");
        ResourceLocation coinCastSingleLocation = new ResourceLocation("tconstruct:casts/single_use/coin");
        ResourceLocation rodCastMultiLocation = new ResourceLocation("tconstruct:casts/multi_use/rod");
        ResourceLocation rodCastSingleLocation = new ResourceLocation("tconstruct:casts/single_use/rod");
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation sheetmetalLocation;
            ResourceLocation rodLocation;
            ResourceLocation coinLocation;
            ResourceLocation gearLocation;
            ResourceLocation plateLocation;
            ResourceLocation dustLocation;
            ResourceLocation nuggetLocation;
            ResourceLocation storageBlockLocation;
            ResourceLocation materialLocation;
            int baseAmount;
            MaterialType type = material.getType();
            String name = material.getName();
            if (type.isDust() || jaopcaOnly && !moltenMaterials.contains(material)) continue;
            ResourceLocation moltenLocation = miscHelper.getTagLocation("molten", name, "_");
            int n = baseAmount = material.getType().isIngot() ? 90 : 100;
            if (!fluidTags.contains(moltenLocation)) continue;
            if (!MATERIAL_BLACKLIST.contains(name) && !configMaterialToMoltenBlacklist.contains(name)) {
                materialLocation = miscHelper.getTagLocation(type.getFormName(), name);
                helper.registerMeltingRecipe(new ResourceLocation("jaopca", "tconstruct.material_to_molten." + name), materialLocation, (Object)moltenLocation, baseAmount, tempFunction, this.getMeltTimeFunction(1.0f), new Object[0]);
            }
            if (!STORAGE_BLOCK_BLACKLIST.contains(name) && !configStorageBlockToMoltenBlacklist.contains(name) && itemTags.contains(storageBlockLocation = miscHelper.getTagLocation("storage_blocks", name))) {
                helper.registerMeltingRecipe(new ResourceLocation("jaopca", "tconstruct.storage_block_to_molten." + name), storageBlockLocation, (Object)moltenLocation, baseAmount * 9, tempFunction, this.getMeltTimeFunction(3.0f), new Object[0]);
            }
            if (!NUGGET_BLACKLIST.contains(name) && !configNuggetToMoltenBlacklist.contains(name) && itemTags.contains(nuggetLocation = miscHelper.getTagLocation("nuggets", name))) {
                helper.registerMeltingRecipe(new ResourceLocation("jaopca", "tconstruct.nugget_to_molten." + name), nuggetLocation, (Object)moltenLocation, (int)Math.floor((float)baseAmount / 9.0f), tempFunction, this.getMeltTimeFunction(0.33333334f), new Object[0]);
            }
            if (!DUST_BLACKLIST.contains(name) && !configDustToMoltenBlacklist.contains(name) && itemTags.contains(dustLocation = miscHelper.getTagLocation("dusts", name))) {
                helper.registerMeltingRecipe(new ResourceLocation("jaopca", "tconstruct.dust_to_molten." + name), dustLocation, (Object)moltenLocation, baseAmount, tempFunction, this.getMeltTimeFunction(0.75f), new Object[0]);
            }
            if (!PLATE_BLACKLIST.contains(name) && !configPlateToMoltenBlacklist.contains(name) && itemTags.contains(plateLocation = miscHelper.getTagLocation("plates", name))) {
                helper.registerMeltingRecipe(new ResourceLocation("jaopca", "tconstruct.plate_to_molten." + name), plateLocation, (Object)moltenLocation, baseAmount, tempFunction, this.getMeltTimeFunction(1.0f), new Object[0]);
            }
            if (!GENERAL_BLACKLIST.contains(name) && !configGearToMoltenBlacklist.contains(name) && itemTags.contains(gearLocation = miscHelper.getTagLocation("gears", name))) {
                helper.registerMeltingRecipe(new ResourceLocation("jaopca", "tconstruct.gear_to_molten." + name), gearLocation, (Object)moltenLocation, baseAmount * 4, tempFunction, this.getMeltTimeFunction(2.0f), new Object[0]);
            }
            if (!COIN_BLACKLIST.contains(name) && !configCoinToMoltenBlacklist.contains(name) && itemTags.contains(coinLocation = miscHelper.getTagLocation("coins", name))) {
                helper.registerMeltingRecipe(new ResourceLocation("jaopca", "tconstruct.coin_to_molten." + name), coinLocation, (Object)moltenLocation, (int)Math.floor((float)baseAmount / 3.0f), tempFunction, this.getMeltTimeFunction(0.6666667f), new Object[0]);
            }
            if (!GENERAL_BLACKLIST.contains(name) && !configRodToMoltenBlacklist.contains(name) && itemTags.contains(rodLocation = miscHelper.getTagLocation("rods", name))) {
                helper.registerMeltingRecipe(new ResourceLocation("jaopca", "tconstruct.rod_to_molten." + name), rodLocation, (Object)moltenLocation, (int)Math.floor((float)baseAmount / 2.0f), tempFunction, this.getMeltTimeFunction(0.2f), new Object[0]);
            }
            if (!GENERAL_BLACKLIST.contains(name) && !configSheetmetalToMoltenBlacklist.contains(name) && itemTags.contains(sheetmetalLocation = miscHelper.getTagLocation("sheetmetals", name))) {
                helper.registerMeltingRecipe(new ResourceLocation("jaopca", "tconstruct.sheetmetal_to_molten." + name), sheetmetalLocation, (Object)moltenLocation, baseAmount, tempFunction, this.getMeltTimeFunction(1.0f), new Object[0]);
            }
            if (!MATERIAL_BLACKLIST.contains(name) && !configToMaterialBlacklist.contains(name)) {
                materialLocation = miscHelper.getTagLocation(type.getFormName(), name);
                if (type.isIngot()) {
                    helper.registerCastingTableRecipe(new ResourceLocation("jaopca", "tconstruct.molten_to_material_gold_cast." + name), ingotCastMultiLocation, moltenLocation, baseAmount, materialLocation, 1, castTimeFunction, false, false);
                    helper.registerCastingTableRecipe(new ResourceLocation("jaopca", "tconstruct.molten_to_material_sand_cast." + name), ingotCastSingleLocation, moltenLocation, baseAmount, materialLocation, 1, castTimeFunction, true, false);
                } else {
                    helper.registerCastingTableRecipe(new ResourceLocation("jaopca", "tconstruct.molten_to_material_gold_cast." + name), gemCastMultiLocation, moltenLocation, baseAmount, materialLocation, 1, castTimeFunction, false, false);
                    helper.registerCastingTableRecipe(new ResourceLocation("jaopca", "tconstruct.molten_to_material_sand_cast." + name), gemCastSingleLocation, moltenLocation, baseAmount, materialLocation, 1, castTimeFunction, true, false);
                }
            }
            if (!STORAGE_BLOCK_BLACKLIST.contains(name) && !configToStorageBlockBlacklist.contains(name) && itemTags.contains(storageBlockLocation = miscHelper.getTagLocation("storage_blocks", name))) {
                helper.registerCastingBasinRecipe(new ResourceLocation("jaopca", "tconstruct.molten_to_storage_block." + name), Ingredient.f_43901_, moltenLocation, baseAmount * 9, storageBlockLocation, 1, castTimeFunction, false, false);
            }
            if (!NUGGET_BLACKLIST.contains(name) && !configToNuggetBlacklist.contains(name) && itemTags.contains(nuggetLocation = miscHelper.getTagLocation("nuggets", name))) {
                helper.registerCastingTableRecipe(new ResourceLocation("jaopca", "tconstruct.molten_to_nugget_gold_cast." + name), nuggetCastMultiLocation, moltenLocation, (int)Math.ceil((float)baseAmount / 9.0f), nuggetLocation, 1, castTimeFunction, false, false);
                helper.registerCastingTableRecipe(new ResourceLocation("jaopca", "tconstruct.molten_to_nugget_sand_cast." + name), nuggetCastSingleLocation, moltenLocation, (int)Math.ceil((float)baseAmount / 9.0f), nuggetLocation, 1, castTimeFunction, true, false);
            }
            if (!PLATE_BLACKLIST.contains(name) && !configToPlateBlacklist.contains(name) && itemTags.contains(plateLocation = miscHelper.getTagLocation("plates", name))) {
                helper.registerCastingTableRecipe(new ResourceLocation("jaopca", "tconstruct.molten_to_plate_gold_cast." + name), plateCastMultiLocation, moltenLocation, baseAmount, plateLocation, 1, castTimeFunction, false, false);
                helper.registerCastingTableRecipe(new ResourceLocation("jaopca", "tconstruct.molten_to_plate_sand_cast." + name), plateCastSingleLocation, moltenLocation, baseAmount, plateLocation, 1, castTimeFunction, true, false);
            }
            if (!GENERAL_BLACKLIST.contains(name) && !configToGearBlacklist.contains(name) && itemTags.contains(gearLocation = miscHelper.getTagLocation("gears", name))) {
                helper.registerCastingTableRecipe(new ResourceLocation("jaopca", "tconstruct.molten_to_gear_gold_cast." + name), gearCastMultiLocation, moltenLocation, baseAmount * 4, gearLocation, 1, castTimeFunction, false, false);
                helper.registerCastingTableRecipe(new ResourceLocation("jaopca", "tconstruct.molten_to_gear_sand_cast." + name), gearCastSingleLocation, moltenLocation, baseAmount * 4, gearLocation, 1, castTimeFunction, true, false);
            }
            if (!GENERAL_BLACKLIST.contains(name) && !configToCoinBlacklist.contains(name) && itemTags.contains(coinLocation = miscHelper.getTagLocation("coins", name))) {
                helper.registerCastingTableRecipe(new ResourceLocation("jaopca", "tconstruct.molten_to_coin_gold_cast." + name), coinCastMultiLocation, moltenLocation, (int)Math.ceil((float)baseAmount / 3.0f), coinLocation, 1, castTimeFunction, false, false);
                helper.registerCastingTableRecipe(new ResourceLocation("jaopca", "tconstruct.molten_to_coin_sand_cast." + name), coinCastSingleLocation, moltenLocation, (int)Math.ceil((float)baseAmount / 3.0f), coinLocation, 1, castTimeFunction, true, false);
            }
            if (GENERAL_BLACKLIST.contains(name) || configToRodBlacklist.contains(name) || !itemTags.contains(rodLocation = miscHelper.getTagLocation("rods", name))) continue;
            helper.registerCastingTableRecipe(new ResourceLocation("jaopca", "tconstruct.molten_to_rod_gold_cast." + name), rodCastMultiLocation, moltenLocation, (int)Math.ceil((float)baseAmount / 2.0f), rodLocation, 1, castTimeFunction, false, false);
            helper.registerCastingTableRecipe(new ResourceLocation("jaopca", "tconstruct.molten_to_rod_sand_cast." + name), rodCastSingleLocation, moltenLocation, (int)Math.ceil((float)baseAmount / 2.0f), rodLocation, 1, castTimeFunction, true, false);
        }
    }

    public ToIntFunction<FluidStack> getMeltTimeFunction(float timeFactor) {
        return stack -> IMeltingRecipe.calcTime((int)(stack.getFluid().getAttributes().getTemperature(stack) - 300), (float)timeFactor);
    }

    static {
        List<String> materials;
        MATERIAL_BLACKLIST = new TreeSet<String>(Arrays.asList("aluminum", "aluminium", "amethyst", "amethyst_bronze", "brass", "brick", "bronze", "cobalt", "constantan", "copper", "debris", "diamond", "electrum", "emerald", "enderium", "gold", "hepatizon", "invar", "iron", "knightslime", "lead", "lumium", "manyullyn", "netherite", "netherite_scrap", "nickel", "osmium", "pewter", "pig_iron", "platinum", "quartz", "queens_slime", "refined_glowstone", "refined_obsidian", "rose_gold", "signalum", "silver", "slimesteel", "soulsteel", "steel", "tin", "tungsten", "uranium", "zinc"));
        STORAGE_BLOCK_BLACKLIST = new TreeSet<String>(Arrays.asList("aluminum", "aluminium", "amethyst", "amethyst_bronze", "brass", "bronze", "cobalt", "constantan", "copper", "diamond", "electrum", "emerald", "enderium", "gold", "hepatizon", "invar", "iron", "knightslime", "lead", "lumium", "manyullyn", "netherite", "nickel", "osmium", "pewter", "pig_iron", "platinum", "quartz", "queens_slime", "refined_glowstone", "refined_obsidian", "rose_gold", "signalum", "silver", "slimesteel", "soulsteel", "steel", "tin", "tungsten", "uranium", "zinc"));
        NUGGET_BLACKLIST = new TreeSet<String>(Arrays.asList("aluminum", "aluminium", "amethyst_bronze", "brass", "bronze", "cobalt", "constantan", "copper", "debris", "electrum", "enderium", "gold", "hepatizon", "invar", "iron", "knightslime", "lead", "lumium", "manyullyn", "netherite", "netherite_scrap", "nickel", "osmium", "pewter", "pig_iron", "platinum", "queens_slime", "refined_glowstone", "refined_obsidian", "rose_gold", "signalum", "silver", "slimesteel", "soulsteel", "steel", "tin", "tungsten", "uranium", "zinc"));
        DUST_BLACKLIST = new TreeSet<String>(Arrays.asList("aluminum", "aluminium", "amethyst_bronze", "brass", "bronze", "cobalt", "constantan", "copper", "electrum", "enderium", "gold", "hepatizon", "invar", "iron", "knightslime", "lead", "lumium", "manyullyn", "netherite", "nickel", "osmium", "pewter", "pig_iron", "platinum", "queens_slime", "refined_glowstone", "refined_obsidian", "rose_gold", "signalum", "silver", "slimesteel", "soulsteel", "steel", "tin", "tungsten", "uranium", "zinc"));
        PLATE_BLACKLIST = new TreeSet<String>(Arrays.asList("aluminum", "aluminium", "amethyst_bronze", "brass", "brick", "bronze", "cobalt", "constantan", "copper", "electrum", "enderium", "gold", "hepatizon", "invar", "iron", "knightslime", "lead", "lumium", "manyullyn", "netherite", "nickel", "osmium", "pewter", "pig_iron", "platinum", "queens_slime", "rose_gold", "signalum", "refined_glowstone", "refined_obsidian", "silver", "slimesteel", "soulsteel", "steel", "tin", "tungsten", "uranium", "zinc"));
        COIN_BLACKLIST = new TreeSet<String>(Arrays.asList("aluminum", "aluminium", "amethyst_bronze", "brass", "bronze", "cobalt", "constantan", "copper", "electrum", "enderium", "gold", "hepatizon", "invar", "iron", "knightslime", "lead", "lumium", "manyullyn", "netherite", "nickel", "osmium", "pewter", "pig_iron", "platinum", "queens_slime", "rose_gold", "signalum", "refined_glowstone", "refined_obsidian", "silver", "slimesteel", "soulsteel", "steel", "tin", "tungsten", "uranium", "zinc"));
        GENERAL_BLACKLIST = new TreeSet<String>(Arrays.asList("aluminum", "aluminium", "amethyst_bronze", "brass", "bronze", "cobalt", "constantan", "copper", "electrum", "enderium", "gold", "hepatizon", "invar", "iron", "knightslime", "lead", "lumium", "manyullyn", "netherite", "nickel", "osmium", "pewter", "pig_iron", "platinum", "queens_slime", "rose_gold", "signalum", "refined_glowstone", "refined_obsidian", "silver", "slimesteel", "soulsteel", "steel", "tin", "tungsten", "uranium", "zinc"));
        configMaterialToMoltenBlacklist = new TreeSet<String>();
        configStorageBlockToMoltenBlacklist = new TreeSet<String>();
        configNuggetToMoltenBlacklist = new TreeSet<String>();
        configDustToMoltenBlacklist = new TreeSet<String>();
        configPlateToMoltenBlacklist = new TreeSet<String>();
        configGearToMoltenBlacklist = new TreeSet<String>();
        configCoinToMoltenBlacklist = new TreeSet<String>();
        configRodToMoltenBlacklist = new TreeSet<String>();
        configSheetmetalToMoltenBlacklist = new TreeSet<String>();
        configToMaterialBlacklist = new TreeSet<String>();
        configToStorageBlockBlacklist = new TreeSet<String>();
        configToNuggetBlacklist = new TreeSet<String>();
        configToPlateBlacklist = new TreeSet<String>();
        configToGearBlacklist = new TreeSet<String>();
        configToCoinBlacklist = new TreeSet<String>();
        configToRodBlacklist = new TreeSet<String>();
        jaopcaOnly = true;
        if (ModList.get().isLoaded("allthemodium")) {
            materials = Arrays.asList("allthemodium", "unobtainium", "vibranium");
            MATERIAL_BLACKLIST.addAll(materials);
            STORAGE_BLOCK_BLACKLIST.addAll(materials);
            NUGGET_BLACKLIST.addAll(materials);
            DUST_BLACKLIST.addAll(materials);
        }
        if (ModList.get().isLoaded("materialis")) {
            materials = Arrays.asList("arcane_gold", "cloggrum", "ebony_psimetal", "fairy", "forgotten_metal", "froststeel", "iesnium", "ivory_psimetal", "neptunium", "pink_slime", "psimetal", "quicksilver", "refined_glowstone", "refined_obsidian", "refined_radiance", "regalium", "shadow_steel", "starmetal", "utherium");
            MATERIAL_BLACKLIST.addAll(materials);
            STORAGE_BLOCK_BLACKLIST.addAll(materials);
            NUGGET_BLACKLIST.addAll(materials);
            DUST_BLACKLIST.addAll(materials);
            PLATE_BLACKLIST.addAll(materials);
            COIN_BLACKLIST.addAll(materials);
            GENERAL_BLACKLIST.addAll(materials);
        }
        if (ModList.get().isLoaded("bettercompat")) {
            Collections.addAll(MATERIAL_BLACKLIST, "aeternium", "amethyst", "black_opal", "certus_quartz", "elementium", "endorium", "fluix", "manasteel", "moonstone", "neptunium", "terminite", "terrasteel", "thallasium");
            Collections.addAll(STORAGE_BLOCK_BLACKLIST, "certus_quartz", "elementium", "endorium", "fluix", "manasteel", "moonstone", "neptunium", "terrasteel");
            Collections.addAll(NUGGET_BLACKLIST, "endorium", "terminite", "thallasium");
        }
        if (ModList.get().isLoaded("tdelight")) {
            materials = Arrays.asList("gildedfern", "hamletite", "rosenquartz");
            MATERIAL_BLACKLIST.addAll(materials);
            STORAGE_BLOCK_BLACKLIST.addAll(materials);
            NUGGET_BLACKLIST.addAll(materials);
            DUST_BLACKLIST.addAll(materials);
            PLATE_BLACKLIST.addAll(materials);
            COIN_BLACKLIST.addAll(materials);
            GENERAL_BLACKLIST.addAll(materials);
        }
        if (ModList.get().isLoaded("natureminerals")) {
            materials = Arrays.asList("astrite", "kunzite", "stibnite", "thounite", "uvarovite");
            MATERIAL_BLACKLIST.addAll(materials);
            STORAGE_BLOCK_BLACKLIST.addAll(materials);
            NUGGET_BLACKLIST.addAll(materials);
            DUST_BLACKLIST.addAll(materials);
            PLATE_BLACKLIST.addAll(materials);
            GENERAL_BLACKLIST.addAll(materials);
        }
        if (ModList.get().isLoaded("taiga")) {
            materials = Arrays.asList("abyssum", "adamant", "astrium", "aurorium", "basalt", "dilithium", "duranite", "dyonite", "eezo", "fractum", "ignitz", "imperomite", "iox", "jauxum", "karmesine", "lumix", "meteorite", "nihilite", "niob", "nucleum", "obsidiorite", "osram", "ovium", "palladium", "prometheum", "proxii", "seismum", "solarium", "terrax", "tiberium", "triberium", "tritonite", "uru", "valyrium", "vibranium", "violium", "yrdeen");
            MATERIAL_BLACKLIST.addAll(materials);
            STORAGE_BLOCK_BLACKLIST.addAll(materials);
            NUGGET_BLACKLIST.addAll(materials);
            DUST_BLACKLIST.addAll(materials);
        }
    }
}

